﻿using System;
using System.Linq;
using Microsoft.SharePoint.Linq;

namespace TestApplication
{
   static class Program
   {
      static void Main()
      {
         const string webUrl = "http://contoso.de/Standorte";
         var listen = new SharePointLists(webUrl);

         // rufen Sie hier eine der unten stehenden Methoden auf
      }

      private static void HoleLaender(string webUrl)
      {
         // Erstelle einen DataContext
         var listen = new SharePointLists(webUrl);
         // Hole die Laender Liste
         EntityList<Land> laender = listen.Laender;
         foreach (Land land in laender)
         {
            // Gib jedes Land auf die Console aus
            Console.WriteLine("{0} seit {1}",
               land.Titel, land.Seit);
         }
      }

      private static void LandHinzufuegen(SharePointLists listen, EntityList<Land> laender)
      {
         // Erstelle ein neues Land
         var land = new Land { Titel = "Spanien", Seit = DateTime.Now };
         // Füge das Land zu den bestehenden Ländern hinzu
         laender.InsertOnSubmit(land);
         // Speichere die Änderungen
         listen.SubmitChanges();
      }

      private static void LandAendern(SharePointLists listen, EntityList<Land> laender)
      {
         // Hole das Land
         Land dk = laender.SingleOrDefault(l => l.Titel == "Dänemark");
         // Änderung des Datums
         dk.Seit = DateTime.Now;
         try
         {
            // Speichere die Änderungen
            listen.SubmitChanges();
         }
         catch (ChangeConflictException conflictException)
         {
            // alle Konflikte auflösen
            //listen.ChangeConflicts.ResolveAll(RefreshMode.KeepChanges);

            // behandle jeden Konflikt einzelnd
            foreach (ObjectChangeConflict conflict in listen.ChangeConflicts)
            {
               if (conflict.IsDeleted)
               {
                  // Land wurde gelöscht, Änderungen verwerfen
                  conflict.Resolve(RefreshMode.KeepCurrentValues);
                  throw new InvalidOperationException(
                     "Das Land wurde gelöscht.");
               }

               foreach (MemberChangeConflict field in conflict.MemberConflicts)
               {
                  // zeige den Konflikt
                  Console.WriteLine("Eigenschaft '{0}', " +
                                    "Ursprünglicher Wert '{1}', " +
                                    "neuer Wert der Datenbank '{2}', " +
                                    "neuer Wert '{3}'",
                                    field.Member.Name,
                                    field.OriginalValue,
                                    field.DatabaseValue,
                                    field.CurrentValue);
               }

               bool nameChanged = conflict.MemberConflicts.
                                    Any(c => c.Member.Name == "Land");
               if (nameChanged)
               {
                  // Name wurde geändert. Abbrechen
                  conflict.Resolve(RefreshMode.KeepCurrentValues);
                  throw new InvalidOperationException(
                     "Der Name wurde geändert.");
               }
               // ein anderes Feld wurde geändert
               conflict.Resolve(RefreshMode.OverwriteCurrentValues);
               // Konflikte gelöst. Speichern der Änderungen
               listen.SubmitChanges();
            }
         }
      }

      private static void LandLoeschen(SharePointLists listen, EntityList<Land> laender)
      {
         // Hole das Land
         Land it = laender.SingleOrDefault(l => l.Titel == "Italien");
         // Verschiebe das Land in den Papierkorb
         laender.RecycleOnSubmit(it);
         // Lösche das Land
         //laender.DeleteOnSubmit(it);
         try
         {
            // Speichere die Änderungen
            listen.SubmitChanges();
         }
         catch (ChangeConflictException conflictException)
         {
            Console.WriteLine("Konflikt beim Löschen: {0}",
                              conflictException.Message);
         }
      }
   }
}
